class US_SB extends ScoreBoard;

#exec Texture Import File=Textures\PlainWhite.bmp Name=PlainWhite Group=ScoreBoard MIPS=ON
#exec Texture Import File=Textures\NetA.bmp Name=NetA Group=ScoreBoard MIPS=ON

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor;
var US_PRI Ordered[32];
var Bot Bots[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;

var Texture Flag;

simulated function DrawCountryFlag( Canvas Canvas, float X, float Y, string Country )
{
local string ImportTexture;

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;

	ImportTexture = "UniversalSoldiers.Flags."$Country;
	Flag = texture(DynamicLoadObject(ImportTexture, class'Texture'));

	Canvas.SetPos( X , Y );
	Canvas.DrawTile(Flag, 48, 32, 0, 0, 48, 32);

}

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local font CanvasFont;

	Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);

	Canvas.bCenter = True;
	Canvas.StrLen("Test", XL, YL);
	ScoreStart = 58.0/768.0 * Canvas.ClipY;
	CanvasFont = Canvas.Font;
	if ( GRI.GameEndedComments != "" )
	{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, ScoreStart);
		Canvas.DrawText(GRI.GameEndedComments, True);
	}
	else
	{
		Canvas.SetPos(0, ScoreStart);
		DrawVictoryConditions(Canvas);
	}
	Canvas.bCenter = False;
	Canvas.Font = CanvasFont;
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, 1);

	Canvas.DrawTile(texture'USlogo', 512, 64, 0, 0, 512, 64);

	//Canvas.DrawText(TGRI.GameName);
	//Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, 68);

	if ( TGRI.FragLimit > 0 )
	{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, 68 + YL);
	}

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawNameAndStats(Canvas Canvas, US_PRI PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, XL3, YL3, Pingeling;
	local int Hours, Minutes, Seconds;
	local Font CanvasFont;
	local bool bLocalPlayer;
	local PlayerPawn PlayerOwner;
	local int Time, Damage;

	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetBigFont( 1600 );
	Canvas.StrLen( "0000", XL, YL );

	//Draw Box:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor.R = 0;
	Canvas.DrawColor.G = 0;
	Canvas.DrawColor.B = 0;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 320, YOffset );
	Canvas.DrawTile(texture'PlainWhite', 640, 1, 0, 0, 8, 8);
	Canvas.SetPos( Canvas.ClipX * 0.5 - 320, YOffset + 41 );
	Canvas.DrawTile(texture'PlainWhite', 640, 1, 0, 0, 8, 8);
	Canvas.SetPos( Canvas.ClipX * 0.5 - 320, YOffset + 1 );
	Canvas.DrawTile(texture'PlainWhite', 1, 40, 0, 0, 8, 8);
	Canvas.SetPos( Canvas.ClipX * 0.5 + 319, YOffset + 1 );
	Canvas.DrawTile(texture'PlainWhite', 1, 40, 0, 0, 8, 8);

	//Draw Background:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 25;
	Canvas.DrawColor.G = 25;
	Canvas.DrawColor.B = 25;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 279, YOffset +1 );
	Canvas.DrawTile(texture'PlainWhite', 598, 40, 0, 0, 8, 8);

	//Draw Talk Face:
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 319, YOffset + 1);
	Canvas.DrawTile(PRI.TalkTexture, 40, 40, 0, 0, 64, 64);

	// Draw Name
	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = CyanColor;

	Canvas.SetPos(Canvas.ClipX * 0.5 - 277, YOffset);
	Canvas.DrawText(PRI.PlayerName, False);
	if ( PRI.bIsABot )
		{
		Canvas.Font = MyFonts.GetSmallFont( 800 );
		Canvas.SetPos(Canvas.ClipX * 0.5 - 277, YOffset + YL);
		Canvas.DrawText("*BOT*", False);
		}

	// Draw Score
	if ( !bLocalPlayer )
		Canvas.DrawColor = LightCyanColor;

	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.SetPos( Canvas.ClipX * 0.5 , YOffset );
	Canvas.DrawText("Score:"@int(PRI.Score), false );

	// Draw US_PRI variables
	if ( !PRI.bIsABot )
		{
		Seconds = Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime;

		Minutes = Seconds / 60;

		Hours   = Minutes / 60;

		Seconds = Seconds - (Minutes * 60);

		Minutes = Minutes - (Hours * 60);

		Damage = US_PRI(PRI).BaseDamage;
		Canvas.SetPos( Canvas.ClipX * 0.5 + 208, YOffset );
		Canvas.DrawText("Level:"@US_PRI(PRI).Level, false );
		Canvas.Font = MyFonts.GetSmallFont( 800 );
		Canvas.SetPos(Canvas.ClipX * 0.5 - 277, YOffset + YL);
		Canvas.DrawText("Time:"@Hours$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds)$", Rank:"@US_PRI(PRI).Rank$", Health:"@US_PRI(PRI).BaseHealth$", Armor:"@US_PRI(PRI).BaseArmor$", Damage:"@Damage$"%", False);
		
		//Draw Ping:
		if ( PRI.Ping < 50 )
			Pingeling = 64;
		else if ( PRI.Ping < 75 )
			Pingeling = 58;
		else if ( PRI.Ping < 100 )
			Pingeling = 52;
		else if ( PRI.Ping < 125 )
			Pingeling = 46;
		else if ( PRI.Ping < 150 )
			Pingeling = 40;
		else if ( PRI.Ping < 175 )
			Pingeling = 34;
		else if ( PRI.Ping < 200 )
			Pingeling = 28;
		else if ( PRI.Ping < 225 )
			Pingeling = 22;
		else if ( PRI.Ping < 250 )
			Pingeling = 18;
		else if ( PRI.Ping < 275 )
			Pingeling = 12;
		else
			Pingeling = 6;
		Canvas.SetPos(Canvas.ClipX * 0.5 + 322, YOffset + 5);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawTile(Texture'NetA', Pingeling, 32, 0, 0, Pingeling, 32);
		
		if ( US_PRI(PRI).Country != "" )
			{
			DrawCountryFlag( Canvas, Canvas.ClipX * 0.5 - 370, YOffset + 4, US_PRI(PRI).Country );
			}
		}
	
}

function SortScores(int N)
{
	local int I, J, Max;
	local US_PRI TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

function ShowScores( canvas Canvas )
{
	local US_PRI PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;
	local font CanvasFont;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Header
	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	
	CanvasFont = Canvas.Font;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.SetPos(0, 160.0/768.0 * Canvas.ClipY);
	//DrawCategoryHeaders(Canvas);

	Canvas.StrLen( "TEST", XL, YL );
	YStart = Canvas.CurY;
	YOffset = 96;
	if ( PlayerCount > 15 )
		PlayerCount = FMin(PlayerCount, (Canvas.ClipY - YStart)/YL - 1);

	Canvas.SetPos(0, 0);
	for ( I=0; I<PlayerCount; I++ )
	{
		YOffset += 44;
		DrawNameAndStats( Canvas, Ordered[I], 0, YOffset, false);
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;
}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Frags"
     DeathsString="Deaths"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
}
